'''
Diese Datei zeigt einige Möglichkeiten und Grenzen von Pandas AI.
'''

# Importieren der noetigen Bibliotheken
import pandas as pd
from pandasai import SmartDataframe
from pandasai.llm import OpenAI

# API einrichten
# YOUR_API_KEY durch Ihren persoenlichen Key ersetzen
llm = OpenAI(api_token='YOUR_API_KEY')

# Dataframe aus Datei einlesen
df = pd.read_csv('bevoelkerung2.csv')

# Dataframe in SmartDataframe umwandeln
df = SmartDataframe(df, config={'llm': llm})

# Moegliche, funktionierende Anfragen an Pandas AI
'''
response = df.chat('Welches Bundesland hat am meisten Einwohnende?')
response = df.chat('Wie viele Einwohnende leben durchschnittlich in einem Bundesland?')
response = df.chat('Wie viele Bundesländer hat Deutschland?')
response = df.chat('Wie viele Menschen wohnen in Rheinland-Pfalz?')
response = df.chat('Zeige die ersten 10 Reihen des Dataframes in Tabellenform')
response = df.chat('What is the shape of the data?')
response = df.chat('Wie heißen die Spalten?')
response = df.chat('Welche Bundesländer hat Deutschland?')
'''

# Einige Anfragen, die nicht funktionieren bzw. das erwartete Ergebnis zurueckliefern
'''
response = df.chat('Wie viele Staaten hab die Vereinigten Staaten von Amerika?')
response = df.chat('Wie viele Einwohnende leben in Deutschland?')
response = df.chat('In welcher Form sind die Daten angeordnet?')
response = df.chat('Welche Länder gibt es auf der Welt?')
'''

# Ausgabe der Antwort
print(response)
